/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CImageList.h,v 1.3 1999/12/05 02:23:34 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CImageList_h	// [
#define Included_CImageList_h

#include "pgpClassesConfig.h"
#include <commctrl.h>

_PGP_BEGIN

// Class CImageList

class CImageList
{
	NOT_COPYABLE(CImageList)

public:
	CImageList();
	CImageList(HIMAGELIST hiList);
	CImageList(PGPInt32 cx, PGPInt32 cy, PGPUInt32 flags, PGPInt32 cInitial, 
		PGPInt32 cGrow);
	~CImageList();

	CImageList&	operator=(HIMAGELIST hiList);

	operator HIMAGELIST() const {return mIList;}
	HIMAGELIST	Get() const {return mIList;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	PGPInt32	AddMasked(HBITMAP bitmap, COLORREF crMask) const;
	PGPBoolean	Draw(PGPInt32 i, HDC hdcDest, PGPInt32 x, PGPInt32 y, 
		PGPUInt32 fStyle) const;

	static PGPBoolean	DragShowNolock(PGPBoolean show);

	PGPBoolean	BeginDrag(PGPInt32 iTrack, PGPInt32 dxHotSpot, 
		PGPInt32 dyHotSpot) const;
	void		EndDrag() const;

	PGPBoolean	DragEnter(HWND hwndLock, PGPInt32 x, PGPInt32 y);
	PGPBoolean	DragMove(PGPInt32 x, PGPInt32 y) const;
	PGPBoolean	DragLeave();

	HICON	GetIcon(PGPInt32 i, PGPUInt32 flags) const;

	void	Create(PGPInt32 cx, PGPInt32 cy, PGPUInt32 flags, 
		PGPInt32 cInitial, PGPInt32 cGrow);
	void	Attach(HIMAGELIST hiList);
	void	Clear();

private:
	PGPBoolean	mWeCreated;

	HIMAGELIST	mIList;
	HWND		mHwndLock;
};


// Class CImageList member functions

inline 
CImageList::CImageList() : mWeCreated(FALSE), mIList(NULL), mHwndLock(NULL)
{
}

inline 
CImageList::CImageList(HIMAGELIST hiList) : 
	mWeCreated(FALSE), mIList(NULL), mHwndLock(NULL)
{
	Attach(hiList);
}

inline 
CImageList::CImageList(
	PGPInt32	cx, 
	PGPInt32	cy, 
	PGPUInt32	flags, 
	PGPInt32	cInitial, 
	PGPInt32	cGrow) : mWeCreated(FALSE), mIList(NULL), mHwndLock(NULL)
{
	Create(cx, cy, flags, cInitial, cGrow);
}

inline 
CImageList::~CImageList()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CImageList& 
CImageList::operator=(HIMAGELIST hiList)
{
	Attach(hiList);
	return *this;
}

inline 
PGPBoolean 
CImageList::IsAttached() const
{
	return IsntNull(mIList);
}

inline 
PGPInt32 
CImageList::AddMasked(HBITMAP bitmap, COLORREF crMask) const
{
	pgpAssert(IsntNull(bitmap));
	return ImageList_AddMasked(mIList, bitmap, crMask);
}

inline 
PGPBoolean 
CImageList::Draw(
	PGPInt32	i, 
	HDC			hdcDest, 
	PGPInt32	x, 
	PGPInt32	y, 
	PGPUInt32	fStyle) const
{
	return ImageList_Draw(mIList, i, hdcDest, x, y, fStyle);
}

inline 
PGPBoolean 
CImageList::DragShowNolock(PGPBoolean show)
{
	return ImageList_DragShowNolock(show);
}

inline 
PGPBoolean 
CImageList::BeginDrag(
	PGPInt32	iTrack, 
	PGPInt32	dxHotSpot, 
	PGPInt32	dyHotSpot) const
{
	return ImageList_BeginDrag(mIList, iTrack ,dxHotSpot, dyHotSpot);
}

inline 
void 
CImageList::EndDrag() const
{
	ImageList_EndDrag();
}

inline 
PGPBoolean 
CImageList::DragEnter(HWND hwndLock, PGPInt32 x, PGPInt32 y)
{
	pgpAssert(IsNull(mHwndLock));

	mHwndLock = hwndLock;
	return ImageList_DragEnter(hwndLock, x, y);
}

inline 
PGPBoolean 
CImageList::DragMove(PGPInt32 x, PGPInt32 y) const
{
	pgpAssert(IsntNull(mHwndLock));
	return ImageList_DragMove(x, y);
}

inline 
PGPBoolean 
CImageList::DragLeave()
{
	pgpAssert(IsntNull(mHwndLock));

	PGPBoolean	result	= ImageList_DragLeave(mHwndLock);
	mHwndLock = NULL;

	return result;
}

inline 
HICON 
CImageList::GetIcon(PGPInt32 i, PGPUInt32 flags) const
{
	pgpAssert(IsAttached());
	HICON	icon	= ImageList_GetIcon(mIList, i, flags);

	if (IsNull(icon))
		THROW_PGPERROR(kPGPError_Win32CommCtrlOpFailed);

	return icon;
}

inline 
void 
CImageList::Create(
	PGPInt32	cx, 
	PGPInt32	cy, 
	PGPUInt32	flags, 
	PGPInt32	cInitial, 
	PGPInt32	cGrow)
{
	Clear();
	mIList = ImageList_Create(cx, cy, flags, cInitial, cGrow);

	if (IsNull(mIList))
		THROW_PGPERROR(kPGPError_Win32CommCtrlOpFailed);

	mWeCreated = TRUE;
}

inline 
void 
CImageList::Attach(HIMAGELIST hiList)
{
	if (mIList == hiList)
		return;

	Clear();

	mWeCreated = FALSE;
	mIList = hiList;
}

inline 
void 
CImageList::Clear()
{
	if (WeCreated())
		ImageList_Destroy(mIList);

	mWeCreated = FALSE;
	mIList = NULL;
}

_PGP_END

#endif	// ] Included_CImageList_h
